<?php
if(!isset($conn)) {
    require_once '../config.php';
}
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0;
$user = $conn->query("SELECT * FROM users WHERE id = $user_id")->fetch_assoc();
?>
<!-- User Info -->
<div class="p-6 border-b">
    <div class="flex items-center space-x-4">
        <div class="w-14 h-14 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center text-white text-xl font-bold">
            <?php echo isset($user['username']) ? strtoupper(substr($user['username'], 0, 1)) : 'U'; ?>
        </div>
        <div>
            <h3 class="font-bold text-gray-800"><?php echo isset($user['username']) ? $user['username'] : 'Guest'; ?></h3>
            <p class="text-sm text-gray-500">
                <?php 
                if(isset($user['is_active']) && $user['is_active']) {
                    echo '<span class="text-green-600">● Active</span>';
                } elseif(isset($user['is_active'])) {
                    echo '<span class="text-red-600">● Inactive</span>';
                }
                ?>
            </p>
        </div>
    </div>
    
    <!-- Balance -->
    <div class="mt-6 bg-gradient-to-r from-blue-50 to-indigo-50 p-4 rounded-xl">
        <p class="text-gray-500 text-sm">Balance</p>
        <p class="text-2xl font-bold text-gray-800">৳<?php echo isset($user['balance']) ? number_format($user['balance'], 2) : '0.00'; ?></p>
    </div>
</div>

<!-- Navigation Links -->
<div class="p-4">
    <ul class="space-y-2">
        <li>
            <a href="dashboard.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-blue-50 hover:text-blue-600 rounded-lg group">
                <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center group-hover:bg-blue-200">
                    <i class="fas fa-tachometer-alt text-blue-600"></i>
                </div>
                <span class="font-medium">Dashboard</span>
            </a>
        </li>
        
        <li>
            <a href="products.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-purple-50 hover:text-purple-600 rounded-lg group">
                <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center group-hover:bg-purple-200">
                    <i class="fas fa-shopping-cart text-purple-600"></i>
                </div>
                <span class="font-medium">Products</span>
            </a>
        </li>
        
        <li>
            <a href="my-orders.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-green-50 hover:text-green-600 rounded-lg group">
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center group-hover:bg-green-200">
                    <i class="fas fa-shopping-bag text-green-600"></i>
                </div>
                <span class="font-medium">My Orders</span>
                <span class="ml-auto bg-green-100 text-green-800 text-xs font-bold px-2 py-1 rounded-full">
                    <?php 
                    $pending_orders = $conn->query("SELECT COUNT(*) as count FROM orders WHERE user_id = $user_id AND status = 'pending'")->fetch_assoc()['count'];
                    echo $pending_orders > 0 ? $pending_orders : '';
                    ?>
                </span>
            </a>
        </li>
        
        <li>
            <a href="deposit.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-emerald-50 hover:text-emerald-600 rounded-lg group">
                <div class="w-8 h-8 bg-emerald-100 rounded-lg flex items-center justify-center group-hover:bg-emerald-200">
                    <i class="fas fa-plus-circle text-emerald-600"></i>
                </div>
                <span class="font-medium">Deposit</span>
            </a>
        </li>
        
        <li>
            <a href="withdraw.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-red-50 hover:text-red-600 rounded-lg group">
                <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center group-hover:bg-red-200">
                    <i class="fas fa-minus-circle text-red-600"></i>
                </div>
                <span class="font-medium">Withdraw</span>
            </a>
        </li>
        
        <li>
            <a href="referrals.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-cyan-50 hover:text-cyan-600 rounded-lg group">
                <div class="w-8 h-8 bg-cyan-100 rounded-lg flex items-center justify-center group-hover:bg-cyan-200">
                    <i class="fas fa-users text-cyan-600"></i>
                </div>
                <span class="font-medium">Referrals</span>
                <span class="ml-auto bg-cyan-100 text-cyan-800 text-xs font-bold px-2 py-1 rounded-full">
                    <?php 
                    $ref_count = $conn->query("SELECT COUNT(*) as count FROM referrals WHERE referrer_id = $user_id AND status = 'paid'")->fetch_assoc()['count'];
                    echo $ref_count > 0 ? $ref_count : '';
                    ?>
                </span>
            </a>
        </li>
        
        <li>
            <a href="transactions.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-yellow-50 hover:text-yellow-600 rounded-lg group">
                <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center group-hover:bg-yellow-200">
                    <i class="fas fa-exchange-alt text-yellow-600"></i>
                </div>
                <span class="font-medium">Transactions</span>
            </a>
        </li>
        
        <li>
            <a href="profile.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-pink-50 hover:text-pink-600 rounded-lg group">
                <div class="w-8 h-8 bg-pink-100 rounded-lg flex items-center justify-center group-hover:bg-pink-200">
                    <i class="fas fa-user text-pink-600"></i>
                </div>
                <span class="font-medium">Profile</span>
            </a>
        </li>
        
        <?php if(isset($user['is_active']) && !$user['is_active']): ?>
        <li class="mt-8">
            <a href="activate.php" class="sidebar-link flex items-center space-x-3 p-3 bg-gradient-to-r from-yellow-400 to-orange-500 text-white rounded-lg group hover:opacity-90">
                <div class="w-8 h-8 bg-white/20 rounded-lg flex items-center justify-center">
                    <i class="fas fa-bolt"></i>
                </div>
                <span class="font-medium">Activate Account</span>
            </a>
        </li>
        <?php endif; ?>
    </ul>
    
    <!-- Logout -->
    <div class="mt-8 pt-8 border-t">
        <a href="logout.php" class="sidebar-link flex items-center space-x-3 p-3 text-gray-700 hover:bg-red-50 hover:text-red-600 rounded-lg group">
            <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center group-hover:bg-red-200">
                <i class="fas fa-sign-out-alt text-red-600"></i>
            </div>
            <span class="font-medium">Logout</span>
        </a>
    </div>
    
    <!-- Referral Link -->
    <?php if(isset($user['referral_code'])): ?>
    <div class="mt-8 p-4 bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl">
        <p class="text-sm text-gray-600 mb-2">Your Referral Code:</p>
        <div class="flex items-center">
            <input type="text" id="refCode" value="<?php echo $user['referral_code']; ?>" 
                   readonly class="flex-1 bg-white border border-gray-300 rounded-l-lg px-4 py-2 text-sm font-mono">
            <button onclick="copyRefCode()" 
                    class="bg-blue-600 text-white px-4 py-2 rounded-r-lg hover:bg-blue-700 transition duration-300">
                <i class="fas fa-copy"></i>
            </button>
        </div>
        <p class="text-xs text-gray-500 mt-2">Share to earn commissions</p>
    </div>
    <?php endif; ?>
</div>

<script>
function copyRefCode() {
    const refCode = document.getElementById('refCode');
    refCode.select();
    refCode.setSelectionRange(0, 99999);
    document.execCommand('copy');
    
    // Show notification
    const btn = event.target.closest('button');
    const originalHTML = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-check"></i>';
    btn.classList.add('bg-green-600');
    
    setTimeout(() => {
        btn.innerHTML = originalHTML;
        btn.classList.remove('bg-green-600');
        btn.classList.add('bg-blue-600');
    }, 2000);
}
</script>